package ru.yandex.solomon.balancer.remote;

import java.util.Set;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.balancer.AssignmentSeqNo;

/**
 * @author Vladimir Gordiychuk
 */
public interface RemoteNodeClient {
    /**
     * @return true if node present in the cluster
     */
    boolean hasNode(String node);

    /**
     * @return list available nodes in the cluster
     */
    Set<String> getNodes();

    CompletableFuture<Void> assignShard(String address, String shardId, AssignmentSeqNo seqNo, long expiredAt);

    CompletableFuture<Void> unassignShard(String address, String shardId, AssignmentSeqNo seqNo, boolean graceful, long expiredAt);

    CompletableFuture<RemoteNodeState> ping(String address, long leaderSeqNo, long expiredAt);
}
