package ru.yandex.solomon.balancer.remote;

import java.time.Clock;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;

import ru.yandex.solomon.balancer.AssignmentSeqNo;

/**
 * @author Vladimir Gordiychuk
 */
public class RemoteNodeImpl extends AbstractRemoteNode {
    private final RemoteNodeClient client;

    public RemoteNodeImpl(String address, long leaderSeqNo, ScheduledExecutorService timer, Clock clock, RemoteNodeClient client) {
        super(address, leaderSeqNo, timer, clock);
        this.client = client;
    }

    @Override
    protected CompletableFuture<RemoteNodeState> ping() {
        var future = client.ping(address, leaderSeqNo, clock.millis() + 5_000);
        trackCall(future);
        return future;
    }

    @Override
    public CompletableFuture<Void> assignShard(String shardId, AssignmentSeqNo seqNo, long expiredAt) {
        var future = client.assignShard(address, shardId, seqNo, expiredAt);
        trackCall(future);
        return future;
    }

    @Override
    public CompletableFuture<Void> unassignShard(String shardId, AssignmentSeqNo seqNo, boolean graceful, long expiredAt) {
        var future = client.unassignShard(address, shardId, seqNo, graceful, expiredAt);
        trackCall(future);
        return future;
    }
}
