package ru.yandex.solomon.balancer.snapshot;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class SnapshotAssignments extends DefaultObject {

    public static final SnapshotAssignments EMPTY = new SnapshotAssignments(List.of(), List.of());

    public final List<SnapshotNode> nodes;
    public final List<SnapshotShard> shards;

    public SnapshotAssignments(List<SnapshotNode> nodes, List<SnapshotShard> shards) {
        this.nodes = nodes;
        this.shards = shards;
    }

    public boolean isEmpty() {
        return nodes.isEmpty() && shards.isEmpty();
    }
}
