package ru.yandex.solomon.balancer;


import java.util.Collection;

import org.junit.Test;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class ResourcesTest {

    @Test
    public void emtpy() {
        var resources = new Resources();
        assertEquals(0d, resources.get(Res.CPU), 0);
        assertEquals(0d, resources.get(Res.MEMORY), 0);
    }

    @Test
    public void setResource() {
        var resources = new Resources();
        resources.set(Res.CPU, 12);
        resources.set(Res.CPU, 42);
        assertEquals(42d, resources.get(Res.CPU), 0);
        assertEquals(0d, resources.get(Res.MEMORY), 0);
    }

    @Test
    public void plus() {
        var one = new Resources();
        one.set(Res.CPU, 2);
        assertEquals(2d, one.get(Res.CPU), 0);

        var two = new Resources();
        two.set(Res.CPU, 3);
        assertEquals(3d, two.get(Res.CPU), 0);

        one.plus(two);
        assertEquals(5d, one.get(Res.CPU), 0);
        assertEquals(0d, one.get(Res.MEMORY), 0);
    }

    @Test
    public void minus() {
        var one = new Resources();
        one.set(Res.CPU, 5);
        assertEquals(5d, one.get(Res.CPU), 0);

        var two = new Resources();
        two.set(Res.CPU, 3);
        assertEquals(3d, two.get(Res.CPU), 0);

        one.minus(two);
        assertEquals(2d, one.get(Res.CPU), 0);
        assertEquals(0d, one.get(Res.MEMORY), 0);
    }

    @Test
    public void copy() {
        var init = new Resources();
        init.set(Res.MEMORY, 1);
        assertEquals(1d, init.get(Res.MEMORY), 0);

        var copy = new Resources(init);
        assertEquals(1d, copy.get(Res.MEMORY), 0);

        init.set(Res.MEMORY, 2);
        assertEquals(2d, init.get(Res.MEMORY), 0);
        assertEquals(1d, copy.get(Res.MEMORY), 0);
    }

    @Test
    public void dominant() {
        var max = new Resources();
        max.set(Res.MEMORY, 100);
        max.set(Res.CPU, 10);

        {
            var use = new Resources();
            use.set(Res.CPU, 8);
            use.set(Res.MEMORY, 20);
            assertEquals(Res.CPU, Resources.dominantResource(use, max));
        }

        {
            var use = new Resources();
            use.set(Res.CPU, 8);
            use.set(Res.MEMORY, 99);
            assertEquals(Res.MEMORY, Resources.dominantResource(use, max));
        }

        {
            var use = new Resources();
            use.set(Res.CPU, 0);
            use.set(Res.MEMORY, 1);
            assertEquals(Res.MEMORY, Resources.dominantResource(use, max));
        }
    }

    @Test
    public void ignoreZero() {
        var max = new Resources();
        max.set(Res.MEMORY, 100);
        max.set(Res.CPU, 0);

        {
            var use = new Resources();
            use.set(Res.CPU, 8);
            use.set(Res.MEMORY, 20);
            assertEquals(Res.MEMORY, Resources.dominantResource(use, max));
        }

        {
            var use = new Resources();
            use.set(Res.CPU, 8);
            use.set(Res.MEMORY, 99);
            assertEquals(Res.MEMORY, Resources.dominantResource(use, max));
        }

        {
            var use = new Resources();
            use.set(Res.CPU, 0);
            use.set(Res.MEMORY, 1);
            assertEquals(Res.MEMORY, Resources.dominantResource(use, max));
        }

    }

    private enum Res implements Resource {
        CPU,
        MEMORY;

        @Override
        public double maximum(Collection<ShardSummary> shards, Collection<NodeSummary> nodes) {
            return 0;
        }
    }
}
