package ru.yandex.solomon.balancer;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author Vladimir Gordiychuk
 */
public class ShardsHolderStub implements ShardsHolder {
    public final ConcurrentHashMap<String, String> shards = new ConcurrentHashMap<>();

    @Override
    public CompletableFuture<Void> reload() {
        return CompletableFuture.runAsync(() -> {});
    }

    @Override
    public Set<String> getShards() {
        return Set.copyOf(shards.keySet());
    }

    @Override
    public CompletableFuture<Void> add(String shardId) {
        return CompletableFuture.runAsync(() -> shards.put(shardId, shardId));
    }

    public void syncAdd(String... shardIds) {
        for (var shardId : shardIds) {
            shards.put(shardId, shardId);
        }
    }

    @Override
    public CompletableFuture<Void> delete(String shardId) {
        return CompletableFuture.runAsync(() -> shards.remove(shardId, shardId));
    }
}
