package ru.yandex.solomon.balancer.dao;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

/**
 * @author Vladimir Gordiychuk
 */
public class YdbBalancerDao2Test extends BalancerDaoTest {

    @ClassRule
    public static LocalKikimr kikimr = new LocalKikimr();

    @Rule
    public TestName testName = new TestName();
    private BalancerDao ydbDao;

    @Before
    public void setUp() {
        var ydb = new YdbHelper(kikimr, this.getClass().getSimpleName() + "_" + testName.getMethodName());
        ydbDao = new YdbBalancerDaoV2(ydb.getRootPath(), ydb.getTableClient(), ydb.getSchemeClient());
        ydbDao.createSchema().join();
    }

    @Override
    public BalancerDao getDao() {
        return ydbDao;
    }
}
