package ru.yandex.solomon.balancer.remote;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

import javax.annotation.Nullable;

import io.grpc.Status;

import ru.yandex.solomon.balancer.AssignmentSeqNo;

/**
 * @author Vladimir Gordiychuk
 */
public class RemoteNodeStub implements RemoteNode {
    public AtomicReference<RemoteNodeState> state = new AtomicReference<>();
    private final String address;

    public RemoteNodeStub() {
        this("unknown");
    }

    public RemoteNodeStub(String address) {
        this.address = address;
    }

    @Override
    public String getAddress() {
        return address;
    }

    @Nullable
    @Override
    public RemoteNodeState takeState() {
        return state.getAndSet(null);
    }

    @Override
    public CompletableFuture<Void> assignShard(String shardId, AssignmentSeqNo seqNo, long expiredAt) {
        return CompletableFuture.failedFuture(Status.UNIMPLEMENTED.asException());
    }

    @Override
    public CompletableFuture<Void> unassignShard(String shardId, AssignmentSeqNo seqNo, boolean graceful, long expiredAt) {
        return CompletableFuture.failedFuture(Status.UNIMPLEMENTED.asException());
    }

    @Override
    public double getFailCommandPercent() {
        return 0;
    }

    @Override
    public void close() {
    }
}
