package ru.yandex.solomon.balancer.www;

import java.time.Duration;

import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static ru.yandex.solomon.balancer.www.BalancerPageWww.formatDuration;

/**
 * @author Vladimir Gordiychuk
 */
public class BalancerPageWwwTest {

    @Test
    public void truncatedFormatUptime() {
        assertEquals("3d", formatDuration(Duration.ofDays(3).plusHours(2).plusMinutes(32).plusSeconds(12).toMillis()));
        assertEquals("2h", formatDuration(Duration.ofHours(2).plusMinutes(32).plusSeconds(12).toMillis()));
        assertEquals("32m", formatDuration(Duration.ofMinutes(32).plusSeconds(12).toMillis()));
        assertEquals("12s", formatDuration(Duration.ofSeconds(12).toMillis()));
    }
}
