 SHELL := /bin/bash

# dirs
ARCADIA_ROOT := $(shell pwd | sed 's|/arcadia/.*|/arcadia|')
TARGET_DIR := target

# tools
YA := $(ARCADIA_ROOT)/ya
CURL := curl -s

ifeq ($(shell uname -s),Linux)
    MD5 = md5sum $(1) | awk '{print $$1}'
    SHA1 = sha1sum $(1) | awk '{print $$1}'
else
    MD5 = md5 -q $(1)
    SHA1 = shasum -a1 $(1) | awk '{print $$1}'
endif

VERSION ?= $(shell svn info | sed -n 's/Revision: //p')

# artifactory
ART_HOST := artifactory.yandex.net
ART_USER := yandexinfradeploy
ART_KEY := $(shell cat ~/.artifactory/key)
ART_REPO := yandex_infra
ART_GROUP_DIR := $(shell echo $(GROUP_ID) | tr '.' '/')
ART_URL := http://$(ART_HOST)/$(ART_REPO)/$(ART_GROUP_DIR)/$(ARTIFACT_ID)

# targets
TARGET_JAR := $(ARTIFACT_ID)-$(VERSION).jar
TARGET_SRC_JAR := $(ARTIFACT_ID)-$(VERSION)-sources.jar
TARGET_POM := $(ARTIFACT_ID)-$(VERSION).pom

info:
	printf "Usage:  make <target>\n\n\
    	\rAvailable targets:\n\
		build    -  build and calculate checksums of the library\n\
		upload   -  build and upload atrifacts into atrifactory\n\
		clean    -  cleanup terget directory\n\
		\r"

$(TARGET_DIR):
	mkdir -p $@

pom.xml:
	$(YA) make --maven-export --sources

$(TARGET_DIR)/$(TARGET_POM): $(TARGET_DIR) pom.xml
	cp $(ARTIFACT_ID).jar $(TARGET_DIR)/$(TARGET_JAR)
	cp $(ARTIFACT_ID)-sources.jar $(TARGET_DIR)/$(TARGET_SRC_JAR)
	sed -e "s|<groupId>ru.yandex</groupId>|<groupId>$(GROUP_ID)</groupId>|" \
		pom.xml > $@

$(TARGET_DIR)/$(TARGET_POM).md5: $(TARGET_DIR)/$(TARGET_POM)
	for f in $(TARGET_DIR)/*.{pom,jar}; do \
        $(call MD5,$$f) > $$f.md5; \
        $(call SHA1,$$f) > $$f.sha1; \
    done

$(TARGET_DIR)/maven-metadata.xml: $(TARGET_DIR)/maven_meta.sh
	( echo $(VERSION); \
        $(CURL) -L $(ART_URL)/ | sed -nr 's|.*<a[^>]+>([0-9]+)/?</a>.*|\1|p' ) | \
        sort -u | xargs ./$(TARGET_DIR)/maven_meta.sh > $@

$(TARGET_DIR)/maven_meta.sh:
	mkdir -p $(@D)
	printf "#!/bin/sh -e\n\n" > $@
	$(MAKE) --no-print-directory -n maven_meta.sh >> $@
	chmod +x $@

maven_meta.sh:
	last_version=$$(echo "$$@" | tr ' ' '\n' | sort -n | tail -n1)
	echo "<metadata>"
	echo "<groupId>$(GROUP_ID)</groupId>"
	echo "    <artifactId>$(ARTIFACT_ID)</artifactId>"
	echo "    <versioning>"
	echo "        <latest>$${last_version}</latest>"
	echo "        <release>$${last_version}</release>"
	echo "        <lastUpdated>$$(date +%Y%m%d%H%M%S)</lastUpdated>"
	echo "        <snapshotVersions/>"
	echo "        <versions>"
	for version in "$$@"; do echo "<version>$${version}</version>"; done
	echo "        </versions>"
	echo "    </versioning>"
	echo "</metadata>"

build: $(TARGET_DIR)/$(TARGET_POM).md5 $(TARGET_DIR)/maven-metadata.xml

upload: build
	for f in $(TARGET_DIR)/*.{pom,jar,md5,sha1}; do \
		$(CURL) -u $(ART_USER):$(ART_KEY) -X PUT -T $$f $(ART_URL)/$(VERSION)/; \
	done

	$(CURL) -u $(ART_USER):$(ART_KEY) -X PUT \
		-T $(TARGET_DIR)/maven-metadata.xml $(ART_URL)/

clean:
	$(RM) -r $(TARGET_DIR) pom.xml $(ARTIFACT_ID).jar $(ARTIFACT_ID)-sources.jar

.PHONY: info build upload clean maven_meta.sh

ifndef VERBOSE
.SILENT:
endif
