package ru.yandex.solomon.cloud.resource.resolver;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.cloud.resourcemanager.ResolvedFolder;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface CloudByFolderResolver {
    CompletableFuture<String> resolveCloudId(String folderId);
    CompletableFuture<Optional<String>> tryResolveCloudId(String folderId);
    CompletableFuture<List<ResolvedFolder>> resolveClouds(Collection<String> folderIds);
}
