package ru.yandex.solomon.cloud.resource.resolver;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
class CloudByFolderResolverMetrics {

    private final Rate cacheHitOk;
    private final Rate cacheHitNotFound;
    private final Rate cacheHitError;
    private final Rate cacheMiss;

    CloudByFolderResolverMetrics() {
        this.cacheHitOk = MetricRegistry.root().rate("cloudByFolderResolver.cacheHitOk");
        this.cacheHitNotFound = MetricRegistry.root().rate("cloudByFolderResolver.cacheHitNotFound");
        this.cacheHitError = MetricRegistry.root().rate("cloudByFolderResolver.cacheHitError");
        this.cacheMiss = MetricRegistry.root().rate("cloudByFolderResolver.cacheMiss");
    }

    void hitOk() {
        cacheHitOk.inc();
    }

    void hitOk(int count) {
        cacheHitOk.add(count);
    }

    void hitNotFound() {
        cacheHitNotFound.inc();
    }

    void hitError() {
        cacheHitError.inc();
    }

    void miss() {
        cacheMiss.inc();
    }

    void miss(int count) {
        cacheMiss.add(count);
    }
}
