package ru.yandex.solomon.cloud.resource.resolver;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.cloud.resourcemanager.ResolvedFolder;
import ru.yandex.solomon.core.exceptions.NotFoundException;

import static java.util.concurrent.CompletableFuture.completedFuture;
import static java.util.concurrent.CompletableFuture.failedFuture;


/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
public class CloudByFolderResolverNoOp implements CloudByFolderResolver {

    @Override
    public CompletableFuture<String> resolveCloudId(String folderId) {
        return failedFuture(new NotFoundException("folder not found by id: " + folderId));
    }

    @Override
    public CompletableFuture<Optional<String>> tryResolveCloudId(String folderId) {
        return completedFuture(Optional.empty());
    }

    @Override
    public CompletableFuture<List<ResolvedFolder>> resolveClouds(Collection<String> folderIds) {
        return completedFuture(List.of());
    }
}
