package ru.yandex.solomon.cloud.resource.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.cloud.resourcemanager.ResolvedFolder;
import ru.yandex.solomon.core.exceptions.NotFoundException;

import static java.util.concurrent.CompletableFuture.supplyAsync;


/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class CloudByFolderResolverStub implements CloudByFolderResolver {
    private final ConcurrentMap<String, String> cloudByFolder = new ConcurrentHashMap<>();

    public void add(String folderId, String cloudId) {
        cloudByFolder.put(folderId, cloudId);
    }

    public String get(String folderId) {
        return cloudByFolder.get(folderId);
    }

    @Override
    public CompletableFuture<String> resolveCloudId(String folderId) {
        return supplyAsync(() -> {
            var cloudId = cloudByFolder.get(folderId);
            if (cloudId == null) {
                throw new NotFoundException("folder not found by id: " + folderId);
            }
            return cloudId;
        });
    }

    @Override
    public CompletableFuture<Optional<String>> tryResolveCloudId(String folderId) {
        return supplyAsync(() -> Optional.ofNullable(cloudByFolder.get(folderId)));
    }

    @Override
    public CompletableFuture<List<ResolvedFolder>> resolveClouds(Collection<String> folderIds) {
        return supplyAsync(() -> {
            List<ResolvedFolder> result = new ArrayList<>();
            for (var folderId : folderIds) {
                var cloudId = cloudByFolder.get(folderId);
                if (cloudId != null) {
                    result.add(new ResolvedFolder(folderId, cloudId));
                }
            }
            return result;
        });
    }
}
