package ru.yandex.solomon.cloud.resource.resolver;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.labels.shard.ShardKey;

import static com.google.common.base.Preconditions.checkArgument;
import static java.util.concurrent.CompletableFuture.supplyAsync;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
public class FolderResolverStub implements FolderResolver {
    private final ConcurrentMap<String, String> cloudByFolder = new ConcurrentHashMap<>();

    public void add(String folderId, String cloudId) {
        cloudByFolder.put(folderId, cloudId);
    }

    @Override
    public CompletableFuture<String> resolveFolderId(ShardKey shardKey) {
        return resolveFolderId(shardKey.getProject(), shardKey.getCluster());
    }

    @Override
    public CompletableFuture<String> resolveFolderId(String projectId, String clusterName) {
        return supplyAsync(() -> {
            var cloud = cloudByFolder.get(clusterName);
            if (cloud == null) {
                return "";
            }

            checkArgument(projectId.equals(cloud), "cloud != project");

            return clusterName;
        });
    }

}
