package ru.yandex.cluster.discovery;

import java.util.Set;
import java.util.concurrent.CompletableFuture;

/**
 * @author Vladimir Gordiychuk
 */
public interface ClusterDiscovery<T extends AutoCloseable> extends AutoCloseable {
    /**
     * @return true if node present in the cluster
     */
    boolean hasNode(String node);

    /**
     * @return list available nodes in the cluster
     */
    Set<String> getNodes();

    /**
     * @return random node from cluster
     */
    T getTransport();

    /**
     * @return connection to specified node
     * @throws io.grpc.StatusRuntimeException if specified node not a part of cluster
     */
    T getTransportByNode(String node);

    CompletableFuture<Void> forceUpdate();

    /**
     * One shot trigger about change cluster membership state
     */
    void callbackOnChange(Runnable oneShotCallback);

    @Override
    void close();
}
