package ru.yandex.cluster.discovery;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

import ru.yandex.discovery.DiscoveryService;
import ru.yandex.grpc.utils.GrpcClientOptions;
import ru.yandex.grpc.utils.GrpcTransport;
import ru.yandex.solomon.util.SolomonEnv;

/**
 * @author Vladimir Gordiychuk
 */
public class GrpcClusterDiscovery {

    public static ClusterDiscovery<GrpcTransport> of(
            GrpcClientOptions opts,
            List<String> unresolvedAddresses,
            ScheduledExecutorService timer,
            Executor executor,
            long reloadIntervalMillis)
    {
        return new ClusterDiscoveryImpl<>(address -> new GrpcTransport(address, opts),
                unresolvedAddresses,
                DiscoveryService.async(SolomonEnv.current(), executor),
                timer,
                executor,
                reloadIntervalMillis);
    }
}
