package ru.yandex.cluster.discovery;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.google.common.net.HostAndPort;

import ru.yandex.discovery.DiscoveryService;

/**
 * @author Vladimir Gordiychuk
 */
public class DiscoveryServiceStub implements DiscoveryService {
    private volatile List<HostAndPort> hostAndPorts = new ArrayList<>();

    @Override
    public CompletableFuture<List<HostAndPort>> resolve(List<String> hosts) {
        return CompletableFuture.supplyAsync(() -> hostAndPorts);
    }

    public void setHosts(String... hosts) {
        hostAndPorts = Stream.of(hosts)
                .map(host -> HostAndPort.fromParts(host, 4700))
                .collect(Collectors.toList());
    }
}
