package ru.yandex.concurrency.limits.actors;

import javax.annotation.Nullable;

/**
 * @author Vladimir Gordiychuk
 */
public class LimiterNoop implements Limiter {
    public static Limiter INSTANCE = new LimiterNoop();

    private LimiterNoop() {
    }

    @Override
    public void addQueueSize(int size) {
    }

    @Override
    public void addQueueTime(long queueTimeMs) {
    }

    @Override
    public void addStatus(OperationStatus status) {
    }

    @Override
    public int inflight() {
        return 0;
    }

    @Override
    public int limit() {
        return 0;
    }

    @Nullable
    @Override
    public OperationPermit acquire() {
        return Permit.INSTANCE;
    }

    @Override
    public void onChange(Runnable runnable) {

    }

    private static record Permit() implements OperationPermit {
        private static final OperationPermit INSTANCE = new Permit();

        @Override
        public void release(OperationStatus status) {
        }
    }

}
