package ru.yandex.concurrency.limits.actors;

import java.util.EnumMap;

import ru.yandex.monlib.metrics.histogram.Histograms;
import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.primitives.Histogram;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.selfmon.counters.EnumMetrics;

/**
 * @author Vladimir Gordiychuk
 */
public class OperationMetrics {
    final Histogram inflight;
    final Histogram limit;
    final Histogram rtt;
    final Histogram minDifference;
    final Histogram queueTime;
    final GaugeInt64 queueSize;
    final EnumMap<OperationStatus, Rate> statuses;

    OperationMetrics(MetricRegistry registry) {
        inflight = registry.histogramRate("operation.limiter.inflight", Histograms.exponential(20, 2));
        limit = registry.histogramRate("operation.limiter.limit", Histograms.exponential(20, 2));
        rtt = registry.histogramRate("operation.limiter.rtt", Histograms.exponential(30, 2));
        minDifference = registry.histogramRate("operation.limiter.rtt_min_difference", Histograms.exponential(13, 2));
        queueTime = registry.histogramRate("operation.limiter.queue_time_ms", Histograms.exponential(30, 2));
        queueSize = registry.gaugeInt64("operation.limiter.total_queue_size");
        statuses = EnumMetrics.rates(OperationStatus.class, registry, "operation.limiter.status", "status");
    }
}
