package ru.yandex.concurrency.limits.actors;


import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

/**
 * @author Vladimir Gordiychuk
 */
public class LimiterImplTest {

    @Test
    public void releaseOnlyOnce() {
        var limiter = LimiterImpl.newBuilder()
                .minLimit(1)
                .maxLimit(2)
                .initLimit(1)
                .build();

        assertEquals(0, limiter.inflight());

        var permit = limiter.acquire();
        assertNotNull(permit);
        assertEquals(1, limiter.inflight());

        permit.release(OperationStatus.SUCCESS);
        assertEquals(0, limiter.inflight());

        permit.release(OperationStatus.SUCCESS);
        assertEquals(0, limiter.inflight());
    }
}
