package ru.yandex.concurrency.limits.actors;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;

/**
 * @author Vladimir Gordiychuk
 */
public class OperationProviderStub implements OperationProvider {
    private final ConcurrentLinkedQueue<Supplier<CompletableFuture<OperationStatus>>> queue = new ConcurrentLinkedQueue<>();

    public void enqueue(Supplier<CompletableFuture<OperationStatus>> supplier) {
        queue.add(supplier);
    }

    @Override
    public boolean hasNext() {
        return !queue.isEmpty();
    }

    @Override
    public CompletableFuture<OperationStatus> next() {
        var supplier = Objects.requireNonNull(queue.poll());
        return supplier.get();
    }
}
