package ru.yandex.solomon.core;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

import ru.yandex.misc.lang.Verify;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.core.conf.aggr.LabelCond;
import ru.yandex.solomon.labels.selector.LabelSelectorSet;


/**
 * Benchmark                          Mode  Cnt         Score         Error  Units
 * AggrRuleConditionMatch.labelCond  thrpt    6  16782097.917 ± 3776317.941  ops/s
 * AggrRuleConditionMatch.selectors  thrpt    6   3833963.728 ± 1124764.667  ops/s
 *
 * @author Sergey Polovko
 */
@State(Scope.Thread)
@Warmup(iterations = 10)
@Measurement(iterations = 3)
@BenchmarkMode(Mode.Throughput)
@OutputTimeUnit(TimeUnit.SECONDS)
@Fork(2)
public class AggrRuleConditionMatch {

    private LabelCond labelCond;
    private LabelSelectorSet selectors;
    private Labels labels;


    @Setup(Level.Iteration)
    public void setUp() throws IOException {
        labelCond = LabelCond.parse(new String[]{"host=*", "fetcher_status=!OK"});
        selectors = LabelSelectorSet.parseEscaped("host=*;fetcher_status=!OK");
        labels = Labels.of(
            "host", "solomon-stp-man-01",
            "path", "/StatusInfo/Count",
            "fetcher_status", "SHARD_NOT_INITIALIZED",
            "shard_id", "kikimr_man_slice_22_messagebus");

        Verify.isTrue(labelCond.allMatch(labels));
        Verify.isTrue(selectors.matchesAll(labels));
    }

    @Benchmark
    public void labelCond() {
        labelCond.allMatch(labels);
    }

    @Benchmark
    public void selectors() {
        selectors.matchesAll(labels);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder()
            .include(AggrRuleConditionMatch.class.getName())
            .build();
        new Runner(opt).run();
    }
}
