package ru.yandex.solomon.core;

/**
 * @author Stepan Koltsov
 */
public class ShardIsNotLocalException extends RuntimeException {

    public ShardIsNotLocalException(String shardId) {
        super("shard " + shardId + " is not local", null, false, false);
    }

    public ShardIsNotLocalException(String shardId, int partId) {
        super("shard " + shardId + " with partition " + partId + " is not local", null, false, false);
    }
}
