package ru.yandex.solomon.core.conf;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.db.model.Cluster;
import ru.yandex.solomon.core.db.model.DecimPolicy;
import ru.yandex.solomon.core.db.model.ServiceMetricConf;
import ru.yandex.solomon.core.db.model.ShardSettings;

/**
 * @author checat
 */
@ParametersAreNonnullByDefault
public class ClusterConfDetailed {

    private final String id;
    private final String name;
    private final Cluster raw;

    public static String getName(Cluster cluster) {
        if (!cluster.getName().isEmpty()) {
            return cluster.getName();
        }
        if (!cluster.getId().isEmpty()) {
            return cluster.getId();
        }
        throw new IllegalArgumentException("neither name nor id set");
    }

    public ClusterConfDetailed(Cluster cluster) {
        id = cluster.getId();
        name = cluster.getName();
        raw = cluster;
    }

    public String getName() {
        return name;
    }

    public String getId() {
        return id;
    }

    public Cluster getRaw() {
        return raw;
    }

    @Override
    public String toString() {
        return "ClusterConfig{" +
                "name='" + name + '\'' +
                ", id='" + id + '\'' +
                "...}";
    }

    public int getMetricsTtlDays() {
        return ShardSettings.getMetricsTtlDays(raw.getShardSettings(), 0);
    }

    public int getGridSec() {
        return ShardSettings.getGrid(raw.getShardSettings(), 0);
    }

    public DecimPolicy getDecimPolicy() {
        return ShardSettings.getDecimPolicy(raw.getShardSettings(), DecimPolicy.UNDEFINED);
    }

    public int getInterval() {
        return ShardSettings.getInterval(raw.getShardSettings(), 0);
    }

    public ServiceMetricConf getMetricConf() {
        return ShardSettings.toServiceMetricConf(raw.getShardSettings(), null);
    }

    public PushOrPull getPushOrPull() {
        return ShardSettings.getPushOrPull(raw.getShardSettings(), null);
    }
}
