package ru.yandex.solomon.core.conf;

import java.util.function.Function;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class ConfMaybeWrongBase<P, C> {
    protected final P raw;
    @Nullable
    protected C conf;
    @Nullable
    protected Throwable throwable;

    ConfMaybeWrongBase(P raw, C conf) {
        this.raw = raw;
        this.conf = conf;
        this.throwable = null;
    }

    ConfMaybeWrongBase(P raw, Throwable throwable) {
        this.raw = raw;
        this.conf = null;
        this.throwable = throwable;
    }

    ConfMaybeWrongBase(P raw, Function<P, C> confMapper) {
        this.raw = raw;
        try {
            conf = confMapper.apply(raw);
            throwable = null;
        } catch (Throwable t) {
            conf = null;
            throwable = t;
        }
    }

    public P getRaw() {
        return raw;
    }

    public C getConfOrThrow() {
        if (throwable != null) {
            throw new RuntimeException("config is incorrect", throwable);
        }
        return conf;
    }

    @Nullable
    public Throwable getThrowable() {
        return throwable;
    }

    public boolean isCorrect() {
        return conf != null;
    }
}
