package ru.yandex.solomon.core.conf;

import javax.annotation.Nonnull;

import ru.yandex.solomon.core.conf.watch.SolomonConfHolder;
import ru.yandex.solomon.staffOnly.manager.ok.OkProvider;

/**
 * @author Nuradil Zhambyl
 */

public class ConfigReadinessChecker implements OkProvider {
    private final SolomonConfHolder confHolder;

    public ConfigReadinessChecker(SolomonConfHolder confHolder) {
        this.confHolder = confHolder;
    }

    @Override
    public String getCheckName() {
        return "config.readiness";
    }

    @Nonnull
    public Status status() {
        boolean ready = confHolder.getConf() != null;
        String message = ready ? "ok" : "conf is not yet loaded";
        return new Status(ConfigReadinessChecker.class.getSimpleName(), ready, message);
    }

    @Nonnull
    @Override
    public Status[] statuses() {
        return new Status[]{status()};
    }
}
