package ru.yandex.solomon.core.conf;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.core.db.model.MenuItem;
import ru.yandex.solomon.core.db.model.ProjectMenu;
import ru.yandex.solomon.labels.FormatLabel;
import ru.yandex.solomon.labels.selector.LabelSelectorSet;

/**
 * @author checat
 */
public class ProjectMenuConfig {

    private final MenuItem[] menuItems;

    public ProjectMenuConfig(ProjectMenu projectMenu) {
        menuItems = projectMenu.getItems();
    }

    public List<MenuItem> constructMenu(Labels labels) {
        return Arrays.stream(menuItems)
            .map(m -> constructMenuItem(m, labels))
            .filter(Optional::isPresent)
            .map(Optional::get)
            .collect(Collectors.toList());
    }

    private Optional<MenuItem> constructMenuItem(MenuItem menuItem, Labels labels) {
        LabelSelectorSet selectors = LabelSelectorSet.parseEscaped(menuItem.getSelectors());

        if (selectors.matchesAll(labels)) {
            if (menuItem.getChildren().length == 0) {
                String url = FormatLabel.formatLabel(menuItem.getUrl(), labels);
                String title = FormatLabel.formatLabel(menuItem.getTitle(), labels);
                return Optional.of(new MenuItem(title, url, new MenuItem[0], ""));
            } else {
                MenuItem[] subMenus =
                    Arrays.stream(menuItem.getChildren())
                        .map(s -> constructMenuItem(s, labels))
                        .filter(Optional::isPresent)
                        .map(Optional::get)
                        .toArray(MenuItem[]::new);

                String title = FormatLabel.formatLabel(menuItem.getTitle(), labels);
                String finalTitle;
                if (title.isEmpty()) {
                    finalTitle = "???";
                } else {
                    finalTitle = title;
                }

                if (subMenus.length > 0) {
                    return Optional.of(new MenuItem(finalTitle, "", subMenus, ""));
                } else {
                    return Optional.empty();
                }
            }
        } else {
            return Optional.empty();
        }
    }
}
