package ru.yandex.solomon.core.conf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.db.model.Selector;
import ru.yandex.solomon.labels.LabelKeys;
import ru.yandex.solomon.labels.selector.LabelSelector;
import ru.yandex.solomon.labels.selector.LabelSelectorSet;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class SelectorUtils {

    public static LabelSelectorSet fromProjectAndParams(String project, Selector[] params) {
        ArrayList<LabelSelector> restrictions = new ArrayList<>(1 + params.length);
        restrictions.add(new LabelSelector(LabelKeys.PROJECT, project));
        restrictions.addAll(Arrays.stream(params)
            .map(p -> new LabelSelector(p.getName(), p.getValue()))
            .collect(Collectors.toList()));
        return new LabelSelectorSet(restrictions);
    }
}

