package ru.yandex.solomon.core.conf;

import javax.annotation.Nullable;

import ru.yandex.solomon.core.db.model.Service;
import ru.yandex.solomon.core.db.model.ServiceProvider;

/**
 * @author Stepan Koltsov
 */
public class ServiceConfMaybeWrong extends ConfMaybeWrongBase<Service, ServiceConfDetailed> {

    ServiceConfMaybeWrong(Service raw, Throwable throwable) {
        super(raw, throwable);
    }

    ServiceConfMaybeWrong(Service proto, @Nullable ServiceProvider serviceProvider) {
        super(proto, service -> new ServiceConfDetailed(service, serviceProvider));
    }

    public String getId() {
        return raw.getId();
    }

    public String getProjectId() {
        return raw.getProjectId();
    }
}
