package ru.yandex.solomon.core.conf;

import javax.annotation.Nonnull;

import ru.yandex.solomon.labels.shard.ShardKey;

/**
 * @author Stepan Koltsov
 */
public class ShardKeyAndId {

    @Nonnull
    private final ShardKey shardKey;
    @Nonnull
    private final String shardId;
    private final int numId;

    public ShardKeyAndId(@Nonnull ShardKey shardKey, @Nonnull String shardId, int numId) {
        this.shardKey = shardKey;
        this.shardId = shardId;
        this.numId = numId;
    }

    @Nonnull
    public ShardKey getShardKey() {
        return shardKey;
    }

    @Nonnull
    public String getShardId() {
        return shardId;
    }

    public int getNumId() {
        return numId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ShardKeyAndId that = (ShardKeyAndId) o;

        if (numId != that.numId) return false;
        if (!shardKey.equals(that.shardKey)) return false;
        return shardId.equals(that.shardId);

    }

    @Override
    public int hashCode() {
        int result = shardKey.hashCode();
        result = 31 * result + shardId.hashCode();
        result = 31 * result + numId;
        return result;
    }

    @Override
    public String toString() {
        return "id=" + shardId + ShardKey.JOIN + shardKey + ShardKey.JOIN + numId;
    }
}
