package ru.yandex.solomon.core.conf;

import java.util.concurrent.CompletableFuture;

/**
 * @author Alexey Trushkin
 */
public interface ShardMetricsQuotaReader {
    CompletableFuture<CurrentQuota> readCurrentMetricsValue(String shardId, String projectId);

    record CurrentQuota(double sensorsPerUrl, double fileSensors, double memSensors, double responseSizeBytes) {
        public static final CurrentQuota EMPTY = new CurrentQuota(0, 0, 0, 0);

        public boolean isEmpty() {
            return (sensorsPerUrl + fileSensors + memSensors + responseSizeBytes) == 0;
        }
    }
}
