package ru.yandex.solomon.core.conf;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.core.db.model.Cluster;
import ru.yandex.solomon.core.db.model.DecimPolicy;
import ru.yandex.solomon.core.db.model.Project;
import ru.yandex.solomon.core.db.model.Service;
import ru.yandex.solomon.core.db.model.ServiceMetricConf;
import ru.yandex.solomon.core.db.model.Shard;
import ru.yandex.solomon.core.db.model.ShardSettings;

/**
 * @author Vladimir Gordiychuk
 */
public class SolomonConfStub {
    private Map<String, Project> projectById = new HashMap<>();
    private Map<Key, Cluster> clusterById = new HashMap<>();
    private Map<Key, Service> serviceById = new HashMap<>();
    private Map<Key, Shard> shardById = new HashMap<>();

    public Shard shard(String projectId, String id) {
        var key = Key.of(projectId, id);
        return shardById.computeIfAbsent(key, k -> Shard.newBuilder()
                .setId(k.id)
                .setNumId(k.hashCode())
                .setProjectId(k.projectId)
                .setServiceId("serviceId-" + k.id)
                .setServiceName("serviceName-" + k.id)
                .setClusterId("clusterId-" + k.id)
                .setClusterName("clusterName-" + k.id)
                .setShardSettings(ShardSettings.of(ShardSettings.Type.UNSPECIFIED,
                        null,
                        0,
                        0,
                        DecimPolicy.UNDEFINED,
                        ShardSettings.AggregationSettings.EMPTY,
                        0))
                .build());
    }

    public Service service(String projectId, String id) {
        var key = new Key(projectId, id);
        return serviceById.computeIfAbsent(key, k -> Service.newBuilder()
                .setId(k.id)
                .setName(k.id)
                .setProjectId(k.projectId)
                .setShardSettings(ShardSettings.of(ShardSettings.Type.UNSPECIFIED,
                        null,
                        15,
                        37,
                        DecimPolicy.UNDEFINED,
                        ShardSettings.AggregationSettings.of(true, new ServiceMetricConf.AggrRule[0], false),
                        20))
                .build());
    }

    public Cluster cluster(String projectId, String id) {
        var key = new Key(projectId, id);
        return clusterById.computeIfAbsent(key, k -> Cluster.newBuilder()
                .setId(k.id)
                .setName(k.id)
                .setProjectId(k.projectId)
                .setShardSettings(ShardSettings.of(ShardSettings.Type.PUSH,
                        null,
                        0,
                        37,
                        DecimPolicy.UNDEFINED,
                        ShardSettings.AggregationSettings.of(true, new ServiceMetricConf.AggrRule[0], false),
                        0))
                .build());
    }

    public Project project(String projectId) {
        return projectById.computeIfAbsent(projectId, id -> Project.newBuilder()
                .setId(projectId)
                .setName(projectId)
                .setOwner("test")
                .build());
    }

    public void addShard(Shard shard) {
        var key = Key.of(shard.getProjectId(), shard.getId());
        shardById.put(key, shard);
        addProject(project(shard.getProjectId()));
        addCluster(cluster(shard.getProjectId(), shard.getClusterId()));
        addService(service(shard.getProjectId(), shard.getServiceId()));
    }

    public void addService(Service service) {
        var key = Key.of(service.getProjectId(), service.getId());
        serviceById.put(key, service);
    }

    public void addCluster(Cluster cluster) {
        var key = Key.of(cluster.getProjectId(), cluster.getId());
        clusterById.put(key, cluster);
    }

    public void addProject(Project project) {
        projectById.put(project.getId(), project);
    }

    public SolomonConfWithContext snapshot() {
        var raw = new SolomonRawConf(
                List.of(),
                List.copyOf(projectById.values()),
                List.copyOf(clusterById.values()),
                List.copyOf(serviceById.values()),
                List.copyOf(shardById.values()));
        return SolomonConfWithContext.create(raw);
    }

    private static class Key extends DefaultObject {
        private final String projectId;
        private final String id;

        private Key(String projectId, String id) {
            this.projectId = projectId;
            this.id = id;
        }

        public static Key of(String projectId, String id) {
            return new Key(projectId, id);
        }
    }
}
