package ru.yandex.solomon.core.conf;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

import ru.yandex.solomon.core.db.model.Project;


/**
 * @author Sergey Polovko
 */
public class SolomonProjectConf {

    private final String id;
    private final String name;
    private final List<ShardConfDetailed> shards;

    public SolomonProjectConf(Project project, List<ShardConfDetailed> shards) {
        this.id = project.getId();
        this.name = project.getName();
        this.shards = shards;
    }

    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public List<ShardConfDetailed> getShards() {
        return shards;
    }

    public boolean hasCluster(String clusterName) {
        for (ShardConfDetailed shard : shards) {
            if (shard.getCluster().getName().equals(clusterName)) {
                return true;
            }
        }
        return false;
    }

    public boolean hasService(String serviceName) {
        for (ShardConfDetailed shard : shards) {
            if (shard.getService().getName().equals(serviceName)) {
                return true;
            }
        }
        return false;
    }

    public List<String> getClusterNames() {
        return findUniqueNames(s -> s.getCluster().getName());
    }

    public List<String> getServiceNames() {
        return findUniqueNames(s -> s.getService().getName());
    }

    private List<String> findUniqueNames(Function<ShardConfDetailed, String> nameMapper) {
        // TODO: can be performed more effectively O(n*log(n) + n) with O(n) additional memory,
        //       But it is java. Who cares?
        return shards.stream()
            .map(nameMapper)
            .distinct()
            .sorted()
            .collect(Collectors.toList());
    }
}
