package ru.yandex.solomon.core.conf;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.salmon.fetcher.proto.FetcherApiProto;
import ru.yandex.solomon.core.db.model.Shard;
import ru.yandex.solomon.proto.UrlStatusType;
import ru.yandex.solomon.util.net.KnownDc;

public class TargetsStatusHelper {
    private static FetcherApiProto.TargetsStatusRequest.Builder createBasicRequest(
            String hostGlob,
            KnownDc dc,
            UrlStatusType status,
            boolean notOkStatus) {
        FetcherApiProto.TargetsStatusRequest.Builder requestBuilder = FetcherApiProto.TargetsStatusRequest.newBuilder();

        if (StringUtils.isNotBlank(hostGlob)) {
            requestBuilder.setHostGlob(hostGlob);
        }
        if (dc != null) {
            requestBuilder.setDc(dc.name());
        }
        requestBuilder.setNotOkStatus(notOkStatus);
        if (!notOkStatus && status != null) {
            requestBuilder.setStatus(status);
        }

        return requestBuilder;
    }

    public static FetcherApiProto.TargetsStatusRequest.Builder requestBuilder(
            String hostGlob,
            KnownDc dc,
            UrlStatusType status,
            boolean notOkStatus,
            Shard shard) {
        var requestBuilder = createBasicRequest(hostGlob, dc, status, notOkStatus);
        requestBuilder.setNumId(shard.getNumId());

        return requestBuilder;
    }

    public static FetcherApiProto.TargetsStatusRequest.Builder requestBuilder(
            String hostGlob,
            KnownDc dc,
            UrlStatusType status,
            boolean notOkStatus,
            String serviceProviderId) {
        var requestBuilder = createBasicRequest(hostGlob, dc, status, notOkStatus);
        requestBuilder.setServiceProviderId(serviceProviderId);

        return requestBuilder;
    }
}
