package ru.yandex.solomon.core.conf;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.urlStatus.UrlStatusTypeAwareException;
import ru.yandex.solomon.proto.UrlStatusType;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class UnknownProjectException extends RuntimeException implements UrlStatusTypeAwareException {

    public UnknownProjectException(String message) {
        super(message);
    }

    @Override
    public UrlStatusType urlStatusType() {
        return UrlStatusType.UNKNOWN_PROJECT;
    }
}
