package ru.yandex.solomon.core.conf;

import ru.yandex.solomon.core.urlStatus.UrlStatusTypeAwareException;
import ru.yandex.solomon.labels.shard.ShardKey;
import ru.yandex.solomon.proto.UrlStatusType;


/**
 * @author Sergey Polovko
 */
public class UnknownShardException extends RuntimeException implements UrlStatusTypeAwareException {

    public static final String IN_NOT_INITIALIZED_MESSAGE = "Metrics storage is not initialized yet, please wait";

    public UnknownShardException(ShardKey key) {
        super("Shard with key \'" + key + "\' was not found");
    }

    public UnknownShardException(int numId) {
        super("Shard with numId \'" + Integer.toUnsignedString(numId) + "\' was not found");
    }

    public UnknownShardException() {
        super(IN_NOT_INITIALIZED_MESSAGE);
    }

    @Override
    public UrlStatusType urlStatusType() {
        return UrlStatusType.UNKNOWN_SHARD;
    }
}
