package ru.yandex.solomon.core.conf.flags;

import java.nio.file.Path;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.type.AnnotatedTypeMetadata;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.core.db.dao.ClusterFlagsDao;
import ru.yandex.solomon.core.db.dao.ProjectFlagsDao;
import ru.yandex.solomon.core.db.dao.ServiceFlagsDao;
import ru.yandex.solomon.core.db.dao.ShardFlagsDao;
import ru.yandex.solomon.flags.FeatureFlag;
import ru.yandex.solomon.flags.FeatureFlagsListener;
import ru.yandex.solomon.util.file.FileStorage;
import ru.yandex.solomon.util.file.SimpleFileStorage;

/**
 * @author Vladimir Gordiychuk
 */
@Configuration
@Import(FeatureFlagsController.class)
public class FeatureFlagsContext {

    private static final Path CACHE_DIR = Path.of("cache");

    private final ThreadPoolProvider threads;
    private final FileStorage storage;

    @Autowired
    public FeatureFlagsContext(ThreadPoolProvider threads) {
        this.threads = threads;
        this.storage = new SimpleFileStorage(CACHE_DIR);
    }

    @Bean
    public FeatureFlagsHolderImpl featureFlagsHolder(MetricRegistry registry) {
        return new FeatureFlagsHolderImpl(storage, registry);
    }

    @Bean
    @Conditional(HasFeatureFlags.class)
    public FeatureFlagsWatcher featureFlagsWatcher(
            ProjectFlagsDao projectDao,
            ClusterFlagsDao clusterDao,
            ServiceFlagsDao serviceDao,
            ShardFlagsDao shardDao,
            FeatureFlagsListener listener)
    {
        var timer = threads.getSchedulerExecutorService();
        return new FeatureFlagsWatcher(storage, timer, projectDao, clusterDao, serviceDao, shardDao, listener);
    }

    private static class HasFeatureFlags implements Condition {
        @Override
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return FeatureFlag.values().length > 1;
        }
    }
}
