package ru.yandex.solomon.core.conf.flags;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.core.conf.SolomonConfWithContext;
import ru.yandex.solomon.core.db.dao.ClusterFlagsDao;
import ru.yandex.solomon.core.db.dao.ProjectFlagsDao;
import ru.yandex.solomon.core.db.dao.ServiceFlagsDao;
import ru.yandex.solomon.core.db.dao.ShardFlagsDao;
import ru.yandex.solomon.flags.FeatureFlag;

/**
 * @author Vladimir Gordiychuk
 */
public class FeatureFlagsOperationDelete extends FeatureFlagsOperation {
    private final ProjectFlagsDao projectDao;
    private final ClusterFlagsDao clusterDao;
    private final ServiceFlagsDao serviceDao;
    private final ShardFlagsDao shardDao;
    private final FeatureFlag flag;

    public FeatureFlagsOperationDelete(
            SolomonConfWithContext config,
            ProjectFlagsDao projectDao,
            ClusterFlagsDao clusterDao,
            ServiceFlagsDao serviceDao,
            ShardFlagsDao shardDao,
            FeatureFlag flag)
    {
        super(config);
        this.projectDao = projectDao;
        this.clusterDao = clusterDao;
        this.serviceDao = serviceDao;
        this.shardDao = shardDao;
        this.flag = flag;
    }

    @Override
    protected CompletableFuture<?> changeProject(String projectId) {
        return projectDao.deleteOne(flag.name(), projectId);
    }

    @Override
    protected CompletableFuture<?> changeServiceProvider(String serviceProvider) {
        return serviceDao.deleteOne(flag.name(), "", serviceProvider);
    }

    @Override
    protected CompletableFuture<?> changeCluster(String projectId, String clusterId) {
        return clusterDao.deleteOne(flag.name(), projectId, clusterId);
    }

    @Override
    protected CompletableFuture<?> changeService(String projectId, String serviceId) {
        return serviceDao.deleteOne(flag.name(), projectId, serviceId);
    }

    @Override
    protected CompletableFuture<?> changeShard(String projectId, String shardId) {
        return shardDao.deleteOne(flag.name(), projectId, shardId);
    }
}
