package ru.yandex.solomon.core.conf.flags;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.core.conf.SolomonConfWithContext;
import ru.yandex.solomon.core.db.dao.ClusterFlagsDao;
import ru.yandex.solomon.core.db.dao.EntityFlagsDao;
import ru.yandex.solomon.core.db.dao.EntityFlagsDao.Record;
import ru.yandex.solomon.core.db.dao.ProjectFlagsDao;
import ru.yandex.solomon.core.db.dao.ServiceFlagsDao;
import ru.yandex.solomon.core.db.dao.ShardFlagsDao;
import ru.yandex.solomon.flags.FeatureFlag;

/**
 * @author Vladimir Gordiychuk
 */
public class FeatureFlagsOperationUpdate extends FeatureFlagsOperation {
    private final ProjectFlagsDao projectDao;
    private final ClusterFlagsDao clusterDao;
    private final ServiceFlagsDao serviceDao;
    private final ShardFlagsDao shardDao;
    private final FeatureFlag flag;
    private final boolean state;

    public FeatureFlagsOperationUpdate(
            SolomonConfWithContext config,
            ProjectFlagsDao projectDao,
            ClusterFlagsDao clusterDao,
            ServiceFlagsDao serviceDao,
            ShardFlagsDao shardDao,
            FeatureFlag flag,
            boolean state)
    {
        super(config);
        this.projectDao = projectDao;
        this.clusterDao = clusterDao;
        this.serviceDao = serviceDao;
        this.shardDao = shardDao;
        this.flag = flag;
        this.state = state;
    }

    @Override
    protected CompletableFuture<?> changeProject(String projectId) {
        return projectDao.upsert(new ProjectFlagsDao.Record(flag.name(), projectId, state));
    }

    @Override
    protected CompletableFuture<?> changeServiceProvider(String serviceProvider) {
        return serviceDao.upsert(new Record(flag.name(), "", serviceProvider, state));
    }

    @Override
    protected CompletableFuture<?> changeCluster(String projectId, String clusterId) {
        return clusterDao.upsert(new EntityFlagsDao.Record(flag.name(), projectId, clusterId, state));
    }

    @Override
    protected CompletableFuture<?> changeService(String projectId, String serviceId) {
        return serviceDao.upsert(new EntityFlagsDao.Record(flag.name(), projectId, serviceId, state));
    }

    @Override
    protected CompletableFuture<?> changeShard(String projectId, String shardId) {
        return shardDao.upsert(new EntityFlagsDao.Record(flag.name(), projectId, shardId, state));
    }
}
