package ru.yandex.solomon.core.conf.watch;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

import javax.annotation.Nullable;

import org.springframework.stereotype.Component;

import ru.yandex.misc.concurrent.CountDownLatches;
import ru.yandex.solomon.core.conf.ShardConfMaybeWrong;
import ru.yandex.solomon.core.conf.SolomonConfWithContext;
import ru.yandex.solomon.staffOnly.annotations.LinkedOnRootPage;
import ru.yandex.solomon.staffOnly.manager.find.annotation.NamedObjectFinderAnnotation;

/**
 * @author Stepan Koltsov
 */
@Component
@LinkedOnRootPage("SolomonConfHolder")
public class SolomonConfHolder implements SolomonConfListener {

    private final AtomicReference<SolomonConfWithContext> conf = new AtomicReference<>();
    private final CountDownLatch initialLoaded = new CountDownLatch(1);

    public SolomonConfWithContext getConfOrThrow() {
        var conf = this.conf.get();
        if (conf == null) {
            throw new IllegalStateException("conf is not yet loaded");
        }
        return conf;
    }

    @Nullable
    public SolomonConfWithContext getConf() {
        return this.conf.get();
    }

    public SolomonConfWithContext getConfOrWait() {
        CountDownLatches.await(initialLoaded);
        return conf.get();
    }

    public ShardConfMaybeWrong shardByNumId(int numId) {
        return getConfOrThrow().getShardByNumId(numId);
    }

    @NamedObjectFinderAnnotation
    public ShardConfMaybeWrong shardByNumIdUnsigned(String numId) {
        return getConfOrThrow().getShardByNumId(Integer.parseUnsignedInt(numId));
    }

    @Override
    public void onConfigurationLoad(SolomonConfWithContext conf) {
        if (this.conf.getAndSet(conf) == null) {
            initialLoaded.countDown();
        }
    }
}
