package ru.yandex.solomon.core.db;

import java.util.Optional;

import com.yandex.ydb.core.rpc.RpcTransport;
import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.TableClient;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.cloud.token.IamTokenClient;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.protobuf.TKikimrClientConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.secrets.SecretProvider;
import ru.yandex.solomon.ydb.YdbClients;


/**
 * @author Sergey Polovko
 */
@Configuration
public class YdbClientsContext implements DisposableBean {

    private final TKikimrClientConfig config;
    private final YdbClients ydbClients;

    public YdbClientsContext(
            @Qualifier("CrossDcKikimrClientConfig") TKikimrClientConfig config,
            ThreadPoolProvider threadPoolProvider,
            MetricRegistry registry,
            Optional<IamTokenClient> iamTokenClient,
            SecretProvider secrets)
    {
        this.config = config;
        this.ydbClients = new YdbClients("CrossDcKikimrClientConfig", config, threadPoolProvider, registry, iamTokenClient, secrets);
    }

    @Bean("globalSchemeClient")
    SchemeClient schemeClient() {
        return ydbClients.getSchemeClient();
    }

    @Bean("globalTableClient")
    TableClient tableClient() {
        return ydbClients.getTableClient();
    }

    @Bean("globalTransport")
    RpcTransport ydbTransport() {
        return ydbClients.getTransport();
    }

    @Bean(name = "globalClientMetrics")
    MetricSupplier tableClientMetrics() {
        return ydbClients.getTableClientMetrics();
    }

    @Bean(name = "configKikimrRootPath")
    public String ydbRootPath() {
        return config.getSchemaRoot();
    }

    @Override
    public void destroy() {
        ydbClients.close();
    }
}
