package ru.yandex.solomon.core.db.dao;

import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.core.db.model.Agent;
import ru.yandex.solomon.ydb.page.PageOptions;
import ru.yandex.solomon.ydb.page.PagedResult;

/**
 * @author Max Sherbakov
 */
public interface AgentDao extends SchemaAwareDao {
    CompletableFuture<Void> insertOrUpdate(Agent agent);
    CompletableFuture<List<Agent>> findAll();
    CompletableFuture<PagedResult<Agent>> findByProvider(String provider, PageOptions pageOpts);
    CompletableFuture<Void> deleteOne(String provider, String url);
    CompletableFuture<Void> deleteByProvider(String provider);
    CompletableFuture<Integer> deleteObsolete(Instant deadline);
}
