package ru.yandex.solomon.core.db.dao;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.core.db.model.Cluster;
import ru.yandex.solomon.selfmon.mon.NameAlias;
import ru.yandex.solomon.ydb.page.PageOptions;
import ru.yandex.solomon.ydb.page.PagedResult;
import ru.yandex.solomon.ydb.page.TokenBasePage;


/**
 * @author snoop
 */
public interface ClustersDao extends SchemaAwareDao {

    /**
     * Add information into the database about new cluster.
     * <p/>
     * It returns <code>false</code> If there is a duplicate cluster in the database.
     * The cluster is identified by {@link Cluster#getId()}.
     *
     * @param cluster the new cluster
     * @return <code>true</code> if the insertion succeeded, or <code>false</code> in otherwise.
     */
    CompletableFuture<Boolean> insert(Cluster cluster);

    CompletableFuture<Optional<Cluster>> findOne(String projectId, String folderId, String clusterId);

    CompletableFuture<PagedResult<Cluster>> findByProjectId(String projectId, String folderId, PageOptions pageOpts, String text);

    CompletableFuture<List<Cluster>> findAll();

    @NameAlias("findAll.paged")
    CompletableFuture<PagedResult<Cluster>> findAll(PageOptions pageOpts, String text);

    CompletableFuture<Optional<Cluster>> partialUpdate(Cluster cluster);

    CompletableFuture<Boolean> deleteOne(String projectId, String folderId, String clusterId);

    CompletableFuture<Void> deleteByProjectId(String projectId, String folderId);

    CompletableFuture<Boolean> exists(String projectId, String folderId, String clusterId);

    CompletableFuture<TokenBasePage<Cluster>> findByProjectIdPaged(String projectId, String folderId, int pageSize, String pageToken, String text);
}
