package ru.yandex.solomon.core.db.dao;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.core.db.SchemaAwareDao;

/**
 * @author Vladimir Gordiychuk
 */
public interface EntityFlagsDao extends SchemaAwareDao {
    CompletableFuture<List<Record>> findAll();
    CompletableFuture<Void> upsert(Record record);
    CompletableFuture<Void> deleteOne(String flag, String projectId, String id);

    class Record extends DefaultObject {
        public String flag;
        public String projectId;
        public String id;
        public boolean value;

        public Record(String flag, String projectId, String id, boolean value) {
            this.flag = flag;
            this.projectId = projectId;
            this.id = id;
            this.value = value;
        }
    }
}
