package ru.yandex.solomon.core.db.dao;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.core.db.model.FolderMenu;


/**
 * @author Oleg Baryshnikov
 */
public interface FolderMenuDao extends SchemaAwareDao {

    CompletableFuture<Optional<FolderMenu>> findById(String projectId, String id);

    CompletableFuture<Boolean> insert(FolderMenu folderMenu);

    CompletableFuture<Optional<FolderMenu>> upsert(FolderMenu folderMenu);

    CompletableFuture<Void> deleteById(String projectId, String id);
}
