package ru.yandex.solomon.core.db.dao;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.core.db.SchemaAwareDao;

/**
 * @author Vladimir Gordiychuk
 */
public interface ProjectFlagsDao extends SchemaAwareDao {
    CompletableFuture<List<Record>> findAll();
    CompletableFuture<Void> upsert(Record record);
    CompletableFuture<Void> deleteOne(String flag, String projectId);

    class Record extends DefaultObject {
        public String flag;
        public String projectId;
        public boolean value;

        public Record(String flag, String projectId, boolean value) {
            this.projectId = projectId;
            this.flag = flag;
            this.value = value;
        }
    }
}
