package ru.yandex.solomon.core.db.dao;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.core.db.model.ProjectMenu;


/**
 * @author snoop
 */
public interface ProjectMenuDao extends SchemaAwareDao {

    CompletableFuture<Optional<ProjectMenu>> findById(String id);

    /**
     * Inserts the given project's menu into the database.
     *
     * @param projectMenu project's menu to insert
     * @return true if insert was successful
     *     false if the database already contains a graph with such id.
     */
    CompletableFuture<Boolean> insert(ProjectMenu projectMenu);

    CompletableFuture<Optional<ProjectMenu>> upsert(ProjectMenu projectMenu);

    CompletableFuture<Void> deleteById(String id);
}
