package ru.yandex.solomon.core.db.dao;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.core.db.model.ProjectSettings;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface ProjectSettingsDao extends SchemaAwareDao {
    CompletableFuture<List<ProjectSettings>> findAll();

    CompletableFuture<ProjectSettings> find(String id);

    CompletableFuture<ProjectSettings> upsert(ProjectSettings projectSettings);

    CompletableFuture<Boolean> delete(String projectId);
}
