package ru.yandex.solomon.core.db.dao;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

import javax.annotation.Nullable;

import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.core.db.model.Project;
import ru.yandex.solomon.core.db.model.ProjectPermission;
import ru.yandex.solomon.ydb.page.PageOptions;
import ru.yandex.solomon.ydb.page.PagedResult;
import ru.yandex.solomon.ydb.page.TokenBasePage;
import ru.yandex.solomon.ydb.page.TokenPageOptions;


/**
 * @author snoop
 */
public interface ProjectsDao extends SchemaAwareDao {

    /**
     * Add information into the database about new project.
     * <p/>
     * It returns <code>false</code> If there is a duplicate project in the database.
     * The project is identified by {@link Project#getId()}.
     *
     * @param project the new project
     * @return <code>true</code> if the insertion succeeded, or <code>false</code> in otherwise.
     */
    CompletableFuture<Boolean> insert(Project project);

    CompletableFuture<Optional<Project>> findById(String id);

    CompletableFuture<List<Project>> findAllNames();

    @Deprecated
    CompletableFuture<PagedResult<Project>> find(
        String text,
        String abcFilter,
        String login,
        @Nullable EnumSet<ProjectPermission> filterByPermissions,
        PageOptions pageOpts);

    CompletableFuture<PagedResult<Project>> findInProjects(
            String text,
            String abcFilter,
            Set<String> projectIds,
            PageOptions pageOpts);

    CompletableFuture<TokenBasePage<Project>> findV3(String text, int pageSize, String pageToken);

    default CompletableFuture<TokenBasePage<Project>> list(TokenPageOptions opts) {
        return CompletableFuture.failedFuture(new UnsupportedOperationException("Not implemented here"));
    }

    CompletableFuture<Optional<Project>> partialUpdate(
        Project project,
        boolean canChangeOwner,
        boolean canChangeInternalOptions,
        boolean canUpdateOldFields);

    CompletableFuture<Void> upsertProjects(List<Project> projects);

    CompletableFuture<Boolean> deleteOne(String id, boolean skipValidation);

    CompletableFuture<Boolean> exists(String id);
}
