package ru.yandex.solomon.core.db.dao;

import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.core.db.model.Quota;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public interface QuotasDao extends SchemaAwareDao {

    CompletableFuture<List<Quota>> findAllByNamespace(String namespace);

    CompletableFuture<List<Quota>> findAllIndicators(String namespace, String scopeType, @Nullable String scopeId);

    CompletableFuture<Void> upsert(String namespace, String scopeType, @Nullable String scopeId, String indicator, long newLimit, String updatedBy, Instant updatedAt);

    CompletableFuture<Void> deleteOne(String namespace, String scopeType, @Nullable String scopeId, String indicator);

    CompletableFuture<Void> delete(String namespace, String scopeType, String indicator);

}
